# Gemini CLI：Google 的免费 AI 命令行工具实测

你好，我是鱼皮。

Google 推出了一个很有意思的 AI 命令行工具 —— Gemini CLI，直接把 AI 塞进了终端里。

![](https://pic.yupi.icu/1/1750927083919-e42152fe-9df9-4686-b813-388ae261b738.png)

根据 [官方介绍](https://github.com/google-gemini/gemini-cli)，这个工具能：

- 处理大型代码库（高达 100 万的 Token 上下文）
- 有多模态能力：能从 PDF 或草图生成新应用
- 能自动化运维：帮你查询代码合并请求、处理复杂的代码合并
- 集成了大量工具：支持连接 MCP 服务器，支持图像、视频、音频生成
- 还有内置搜索等等

对标 Claude Code，现在还有免费使用额度、而且最好的是代码开源！

![](https://pic.yupi.icu/1/image-20260112165459541.png)

截止到 2026 年 1 月，Gemini CLI 已经有 **9 万+ GitHub Stars**，火箭式涨星！

那这个工具到底怎么样呢？我来带大家实际体验一下，说说我自己真实的使用感受。

⭐️ 推荐观看视频版：[https://bilibili.com/video/BV1LuKdzjEAc](https://www.bilibili.com/video/BV1LuKdzjEAc/)



## 一、安装和启动

按照官方提供的文档，我们要先安装 Node.js 运行环境，直接去 [官网](https://nodejs.org/) 安装就好了，**注意版本要 >= 20**（2026 年最新要求）。

然后打开终端，输入一行命令全局安装工具：

```bash
npm install -g @google/gemini-cli
```

或者用 Homebrew 安装（macOS/Linux）：

```bash
brew install gemini-cli
```

安装完成后，输入 `gemini` 命令，做一些基础的设置：

![](https://pic.yupi.icu/1/1750927215041-aef86c7f-90b6-41e1-8509-cb53809372dd.png)

接下来是关键了，需要经过一波账号验证，个人用户选第一项就好。

![](https://pic.yupi.icu/1/1750927255279-3b2d860a-c514-492a-8b27-a8abe27b4b31.png)

这里大家可能会遇到 2 种验证失败的情况，第一种是网络原因（这个不好搞），第二种是说账号类型不符合要求，如图：

![](https://pic.yupi.icu/1/1750927301003-4937f694-3fc9-493f-8309-e169439f59fa.png)

对于第二种情况，解决方案很简单。进入 [Google Cloud](https://console.cloud.google.com/) 控制台，新建一个项目得到 `project_id`：

![](https://pic.yupi.icu/1/1750927486133-ecf76c02-ba82-4f85-adfe-4d168247bee6.png)

然后在终端输入下列命令设置环境变量，重试就能登录进去了：

```bash
export GOOGLE_CLOUD_PROJECT=<你的 project_id>
```

登陆成功后，我们就可以开始使用了。



## 二、实战测试

接下来我选了 8 个不同的场景来从多个方面验证它的能力，大家也可以感受下 Gemini CLI 的真实水平到底如何，大家说好才是真的好。

![](https://pic.yupi.icu/1/1750928002955-c44764ed-abd4-4568-ad07-954d909aa360.png)

### 1、基础问答

输入提示词：

```
你好，请问你能做些什么？有什么优势？
```

结果没想到，一上来就报错了？而且各种胡言乱语。

![](https://pic.yupi.icu/1/1750928093701-0a2cdf6c-483c-4198-8933-00268b7ca2af.png)

过了一会儿，终于满屏飘红了，看报错的意思是我没开启 API 权限：

![](https://pic.yupi.icu/1/1750928146165-9359e7e2-0dfa-4b7e-b3bb-31bfcf94b540.png)

直接访问错误信息中的网址，就能去控制台开启 API 权限了，开一下开一下：

![](https://pic.yupi.icu/1/1750928172586-6ec6dd3b-db41-4fb3-b096-e933936e1e37.png)

再来！这次 AI 的回复就对味儿了，他说自己是个AI软件工程师，确保操作的透明和安全。结果还可以，就是速度有点小慢啊，这么一个简单的问题花了 20 秒，这也是智能体的一个副作用吧。

![](https://pic.yupi.icu/1/1750928224341-15221ba1-7dd2-462a-91f2-f9d832eda07c.png)



### 2、网页搜索

输入提示词，让 AI 自动上网下载表情包：

```markdown
请帮我获取 10 张健康的熊猫头表情包，并且下载到当前目录下
```

结果 AI 给我推荐了几个表情包网站，无法直接下载：

![](https://pic.yupi.icu/1/1750928294365-8a9833e9-a05a-413f-8090-af944d2b4daf.png)

是不是不支持下载工具啊？

我们输入下 `/` 键，就可以看到 Gemini CLI 支持的命令：

![](https://pic.yupi.icu/1/1750928337773-c1fec292-a628-4b3d-93e4-a8846ab7b5b2.png)

进入查看工具列表，发现好像没有网页资源下载工具，也是难为 AI 了。但是它支持编写 Shell 脚本，所以我们不妨引导 AI 编写脚本来实现资源下载。

![](https://pic.yupi.icu/1/1750928445912-9ba1f2bd-2262-499b-bec0-0f5caf967a47.png)

提示词：

```markdown
请帮我获取 10 张健康的熊猫头表情包，并且下载到当前目录下，你可以通过编写可执行脚本来实现图片的下载
```

这次就可以看到智能体开始自主规划任务了，先创建了一个脚本，然后 “写文件” 操作需要我们确认，这里建议选择仅允许一次，安全一些：

![](https://pic.yupi.icu/1/1750928484880-802fa820-8ebe-44d2-963e-34b4eeca590c.png)

遇到问题它会尝试 **重新规划** 然后重试，这也是智能体的一个关键能力：

![](https://pic.yupi.icu/1/1750928516938-edbd9bb5-1507-4835-a83f-fa64ab5bed4d.png)

任务执行完后还记得清理脚本，这个很不错。

![](https://pic.yupi.icu/1/1750928581541-3e1fdfc3-f18b-4202-9b74-b7e351cce7fd.png)

好了，大功告成，我们看看下载好的文件，这个尺寸是认真的么？果然翻车了，下载的图片根本不对！

![](https://pic.yupi.icu/1/1750928679026-e945b956-7b1c-40ae-b941-5c41afbab70f.png)



### 3、文件操作

输入下列提示词，让 AI 帮忙处理我本地的表情包文件：

```markdown
帮我把所有的表情包尺寸放大 1 倍，并且转换为 WEBP 格式，然后将所有表情包组合在一起生成为 GIF
```

然后应该要指定文件路径吧，不然 AI 可能不知道要处理什么。

结果当我输入 `@` 键指定文件路径时，好家伙，输入框直接卡死了？该说不说，这个交互体验不够好，我每次选择文件都会卡，而且选择不了目录。

![](https://pic.yupi.icu/1/1750928995135-adc3d93a-6afc-4c0e-b971-5ba627ec3fc5.png)

经过一番折腾，我发现 得慢点选择，跟着程序列举出的目录树进行选择，就先选一个图片吧：

![](https://pic.yupi.icu/1/1750929221785-9d4261ea-92e5-439e-b038-54ccb9bcfa33.png)

好，这次 AI 聪明了，问我是不是要处理多个文件，必须的：

![](https://pic.yupi.icu/1/1750929281202-176c6599-3e3c-4b0c-93ba-2462c91bf375.png)

然后 AI 发现无法处理图片，要下载一个图片处理工具，然后它说要利用 Mac 上的软件包管理工具来安装，同意即可：

![](https://pic.yupi.icu/1/1750929456285-d75c4e55-2593-424c-8bf0-1e52222305eb.png)

经过漫长的等待，等了快 10 分钟竟然还没好？！

![](https://pic.yupi.icu/1/1750929498503-93b9d475-97a3-4979-92b5-c1538dce9396.png)

可能是我自己的网络原因吧，但我实在等不下去了。老实说测到这里，我心态都已经有点崩了，凌晨两点半隔这儿等软件安装？

![](https://pic.yupi.icu/1/1750929564667-ba06cda8-cd5e-44b5-afac-28c62e3af961.png)

不是，这玩意你写个简单的 Python 脚本不就搞定了？

感觉这个工具还是得给程序员用，要稍微加一些引导，比如我们让 AI 利用 Python 脚本实现任务：

```markdown
帮我把所有的表情包尺寸放大 1 倍，并且转换为 WEBP 格式，然后将所有表情包组合在一起生成为 GIF，使用 Python 脚本实现
```

可以看到 AI 安装了图像处理库，然后创建了一个虚拟环境，你别说它对安全性的考虑还是 ok 的：

![](https://pic.yupi.icu/1/1750929702268-23a76696-f001-444f-8986-f28ad42d3b39.png)

然后编写脚本并执行：

![](https://pic.yupi.icu/1/1750929740570-990bbe0f-f685-4e7d-be7f-ef53402882e5.png)

任务成功完成，看下效果：

![](https://pic.yupi.icu/1/1750929779663-14caecd9-ae80-4727-bc3f-0542fbdf71fe.png)

尺寸确实放大了，格式也转换成功了，GIF 也成功生成了。终于顺利完成了一次任务，还不戳。通过这种方式处理本地图片确实是要比网页端的 AI 应用方便很多。



### 4、生成代码

输入下列提示词，让 AI 帮我做个像素摄影网站：

```markdown
请帮我制作一个网站，能够调用摄像头进行拍照，并将照片转为像素风，支持下载，要求界面简洁炫酷
```

这次生成速度还是挺快的，就是过程中得多次进行人工确认：

![](https://pic.yupi.icu/1/1750929959173-97f40707-bbcc-4cba-a021-4e3c9e7372d4.png)

我们来看下生成的网站效果：

![](https://pic.yupi.icu/1/1750930213995-9ca12c77-e2f4-4626-9da4-8f2783d73eeb.png)

可以调整像素的密度，还可以一键下载照片，效果还是挺不错的，这次任务 AI 也顺利完成了~

![](https://pic.yupi.icu/1/1750930254795-38b8adcb-3a87-44dd-99d4-0b37532ae1fc.png)



### 5、解释代码

给刚刚生成的项目补充一个学习指南，输入提示词：

```markdown
帮我生成该项目的学习指南，帮助新开发者快速上手
```

由于 AI 有上下文，它直接 get 到了我想让他分析哪个项目，然后很快生成了一个项目文档。

![](https://pic.yupi.icu/1/1750930402860-d39c7707-0e3d-4cc8-aaeb-dbf9344589e4.png)

然后我让 AI 帮我打开文档文件：

![](https://pic.yupi.icu/1/1750930530481-8b8f0abf-30fd-48ff-b36c-61b168af2cde.png)

本来是想让 AI 直接打开 Markdown 阅读软件的，但没想到它直接给我输出了一堆无关的内容，我表示不理解。

![](https://pic.yupi.icu/1/1750930702812-27e5e920-9e3c-48f7-8957-60025b80b773.png)

那我自己打开好了吧，生成的文档内容还是过关的，标准的 GitHub 开源项目文档。

![](https://pic.yupi.icu/1/1750930759557-f4b0a16f-d1c8-46fe-b0e5-21910a2bf752.png)



### 6、生成架构图

好，鉴于刚刚的任务完成得还可以，我们加大难度。让 AI 生成一个项目的分层架构图：

```markdown
帮我针对当前项目，生成分层架构图
```

结果就有点乌龙了，AI 给我生成了一个架构设计文档：

![](https://pic.yupi.icu/1/1750930929870-b368fc52-c779-42f0-9ad5-fb056b99ef84.png)

你管这纯英文文档叫做架构图？

![](https://pic.yupi.icu/1/1750930979557-8ab249fe-727e-4041-99b7-9e154a742090.png)

那我再发挥一下仅存的专业性，让他帮我生成架构图的绘图代码：

```markdown
帮我针对当前项目，生成分层架构图的 draw.io 代码
```

这次看着靠谱多了：

![](https://pic.yupi.icu/1/1750931031112-0247644b-2626-459a-ae81-a240ad782400.png)

来，我们把 AI 生成的架构图代码文件拖到 draw.io 中打开。

不是哥们？你管这叫架构图？

![](https://pic.yupi.icu/1/1750931055227-1e674680-468c-4c4d-b182-8bd3026c993e.png)

来，同样的任务，我们用 Cursor + Claude 4 试一试。

哎，你看人家 Claude 很有自信，说 “我可以为您生成一个更完整和详细的分层架构图”：

![](https://pic.yupi.icu/1/1750931203239-924cc09e-c80f-4acf-9855-66d6b4102cac.png)

好，看下生成后的效果，是不是高下立判啊！

![](https://pic.yupi.icu/1/1750931312134-a573f7ff-07ca-4852-830a-07d74bc21690.png)



### 7、生成可视化图表

让 AI 帮我分析项目的提交记录，输入提示词：

```markdown
根据当前项目的提交记录，生成可视化图表，便于我来分析项目的发展历程
```

可以看到 AI 使用 git log 命令查看代码提交记录，然后开始生成图表。

![](https://pic.yupi.icu/1/1750931424995-0e5cd8c2-1dfe-4f09-ac29-c08b1c1388b4.png)

等等？图表在哪儿呢？？？

我的预期肯定是生成一个图片，或者起码是一个字符画，看着像图也行啊，有点为难他了。



### 8、多模态

等验证到多模态的时候已经是凌晨 3 点，我都已经麻了，唉，最后再坚持试试多模态吧。

输入生成图片提示词：

```markdown
帮我基于当前目录下的图片，生成一个风格相似的新图片
```

这次 AI 干脆直接拒绝了，不支持图片创作，你倒是写个脚本啊？！你不用 AI，用个图像处理也行对不对？

![](https://pic.yupi.icu/1/1750931630520-47da3d4e-c55e-4b1c-9507-17dd0f08cb1e.png)

那再解释个图片试试，输入解释图片提示词：

```markdown
帮我解释当前目录下所有的图片
```

这倒是解释出来了，吐槽一下，竟然还是英文输出，可能跟程序本身的语言设定有关吧，体验没有那么好。

![](https://pic.yupi.icu/1/1750931670952-251c1eb3-487a-44ca-b217-194f92a5442a.png)

Gemini CLI 背后用的应该是 Gemini 2.5 Pro 模型，是具有原生多模态输入能力的，也就是说能识图，但是并不能创作图片，包括创作音频和视频应该都是通过第三方大模型（或者 MCP 工具实现的）。

最后再让他解释个 PDF 吧，输入提示词：

```markdown
帮我总结 PDF 的内容，并生成一个新的 PDF
```

结果出乎我意料了，AI 提示输入超出了 token 限制？

![](https://pic.yupi.icu/1/1750931736351-d36ac39e-23ce-42c1-af30-d1f56284d48a.png)

不是号称 100 万 token 上下文么，怎么读个微型 PDF 就超出限制了呢？你无法生成 PDF 我都不觉得奇怪，我这个 PDF 文件就那几个字几张图，为什么？

![](https://pic.yupi.icu/1/1750931817587-41d3c5ef-aca8-4ba6-b89a-a1d55c739c61.png)

本来还想让他生成音频和视频的，算了算了，我对这个工具已经有一些自己的判断了。



## 三、Gemini CLI 的优缺点

测试了 8 个维度后，我的感受是 **一言难尽**，可能是我对 Google 预期太高了吧。

### 优点

先说说优点。**终端操作本地文件确实更方便**，而且它可以直接一行命令安装，在已有的终端中使用，不用重新下载一个终端软件，这点还是不错的。

而且 Gemini CLI 最大的优势是 **完全免费**（有免费额度），支持 Gemini 2.5 Pro 模型，100 万 Token 上下文窗口，每天 1000 次请求。对于预算有限的开发者来说，这是个很好的选择。

另外，Gemini CLI 是 **完全开源** 的（Apache 2.0 协议），支持 MCP 服务器集成，可以扩展各种功能。

### 缺点

但是问题也很明显。

首先是 **AI 智能体的效果一般**，对自然语言理解能力不够，会多干、干跑偏、干错。而且速度比较慢，简单的问题也要等很久。

其次是 **交互体验不够好**。终端的交互体验确实是不如网页和客户端的，很难看到思考过程，界面展示和交互效果也就那样。文件选择器经常卡顿，选择文件很不方便。

还有就是 **使用门槛比较高**。非程序员使用它的门槛还是比较高的，需要熟悉终端操作。而且有些功能需要额外配置，比如 Google Cloud Project。

### 适合什么人？

利用 AI 来生成一下终端命令我觉得很棒（比如 Warp AI），但如果你非要在这个框里使用 AI 来生成内容，我觉得大可不必吧。

Gemini CLI 可能对擅长 Linux 服务器操作的技术大佬还有点用，但是在公司服务器上用这个还是要注意安全性。



## 写在最后

看到这里，相信你已经对 Gemini CLI 有了全面的了解。

我觉得 Gemini CLI 中规中矩吧，没有到网上铺天盖地吹嘘的那种程度。现阶段这玩意更适合尝鲜和学习，而不是作为日常提效工具来使用。

不过虽然现在体验一般，考虑到 Google 的技术实力、还有开源免费的发展模式，我相信随着版本迭代，这工具也会越来越好的。**而且对我们来说多一种工具的选择，总不是坏事。**

如果你预算有限，又想尝试命令行 AI 工具，Gemini CLI 是个不错的选择。但如果你追求最好的体验，还是建议用 Claude Code。

大家觉得这个工具怎么样呢？欢迎评论区留言。感兴趣的同学也可以体验一下，看看是不是和我的感受相同，还是说有一些正确的使用方式
和技巧，也欢迎评论区分享。学编程和 AI 的同学，记得关注鱼皮哦~


## 推荐资源

1）鱼皮 AI 导航网站：[AI 资源大全、最新 AI 资讯、免费 AI 教程](https://ai.codefather.cn)

2）编程导航学习圈：[学习路线、编程教程、实战项目、求职宝典、交流答疑](https://www.codefather.cn)

3）程序员面试八股文：[实习/校招/社招高频考点、企业真题解析](https://www.mianshiya.com)

4）程序员写简历神器：[专业模板、丰富例句、直通面试](https://www.laoyujianli.com)

5）1 对 1 模拟面试：[实习/校招/社招面试拿 Offer 必备](https://ai.mianshiya.com)
